// Sandbox735004Mod01.fsh remixed from
// http://glslsandbox.com/e#73500.4
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
#define time u_Elapsed*(-1.0) //*0.01 
#define resolution u_WindowSize
#define mouse vec4(0.0,0.0,0.0,0.0)
#ifdef GL_ES
precision mediump float;
#endif
#extension GL_OES_standard_derivatives : enable

float map(vec3 p) {
	float tm = time*(3.141592);
	float t = length(p + vec3(cos(tm * 0.25), -sin(tm * 0.3), -cos(tm * 0.4)) * 0.2) - 0.2;
	float angle = tm * -1.0;  
	float delta = (2.0 * 3.141592) /32.0; //2.0 affects grouping of bars over 360 rotation, 32 = number of bars
	for(int i = 0; i < 32; i++) {
		float c = cos(angle) * 2.0;
		float s = sin(angle) * 2.0;
		angle += delta;
		t = min(t, length(p + vec3(c, 1.4, s)) - 0.1);  //the base
		t = min(t, length(p.xz + vec2(c, s)) - 0.02);  //the cage
	}
	 t = min(t, 1.5 - dot(abs(p), vec3(0, 1, 0)));  //the green floor
	return t;
}

vec3 getnor(vec3 p) {
	float t = map(p);
	vec2 d = vec2(0.001, 0.0);
	return normalize(vec3(
		t - map(p + d.xyy),
		t - map(p + d.yxy),
		t - map(p + d.yyx)));
}

void main( void ) {
	vec2 uv = ( 2.0 * gl_FragCoord.xy - resolution.y ) / min(resolution.xy, resolution.x);
	vec3 dir = normalize(vec3(uv + vec2(-0.44, 0.25), 1.0)); 
	vec3 pos = vec3(0, -0.8, -3.0);  //z influences open or closes pole loop
	float t = 1.5; 
	for(int i = 0; i < 38; i++) {
		t += map(dir * t + pos);
	}
	vec3 ip = dir * t + pos;
	vec3 N = getnor(ip);
	vec3 L = normalize(vec3(1,-2,3));
	vec3 PL = vec3(0,3.141592,0); 
	vec3 V = normalize(ip - PL);
	float D = max(0.02, pow(dot(V, N), 2.0));
	gl_FragColor = vec4(abs(N * 0.2) + t * D * vec3(1.0) * map(ip - dir * 0.2) * 2.0, 1.0);
}
